% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

% Data moments for estimation
datamoms        = cell(1,2);
%% Moments collected from Compustat
% Fraction of adjusters
datamoms{1,1}   = .619462;
datamoms{1,2}   = 'Average fraction R>0             ';
% Fraction of firms with R > 0, average over time

% Amount of capital reallocation
datamoms{2,1}   = .0573176 ;
datamoms{2,2}   = 'Average R/K                      ';
% Aggregate capital reallocation divided by aggregate net capital

% Standard deviation of log TFPR
datamoms{3,1}   = .3630209;
datamoms{3,2}   = 'Standard deviation of log TFPR   ';
% Weighted by value-added.
% This is the median (across all years) standard deviation of log TFP,
% calculated across all firms, weighted by their VA-share.

%% Untargeted moments

% AR(1) coefficient of firm-level log(sales)
datamoms{4,1}   = .9075776;
datamoms{4,2}   = 'AR(1) of firm-level log(sales)   ';

% Correlation between productivity and reallocation rate
datamoms{5,1}   = 0.0535;
datamoms{5,2}   = 'Corr APK & reallocation          ';

% Serial correlation of plant-level capital reallocation
datamoms{6,1}   =  .0036434;
datamoms{6,2}   = 'AR(1) of micro reallocation rates';

% Importance of small capital reallocation rates
datamoms{7,1}   =  .8309914;
datamoms{7,2}   = 'Fraction of small R/K rates      ';

